

<?php $__env->startSection('title', 'Permisos'); ?>

<?php $__env->startSection('content'); ?>

<div class="container">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 style="color:#FCCB00;">Listado de Permisos</h4>
        <a href="<?php echo e(route('permisos.create')); ?>" class="btn btn-primary">+ Nuevo Permiso</a>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="table-responsive">
        <table class="table mg-table table-bordered table-hover align-middle text-center">
            <thead>
                <tr>
                    <th>Empleado</th>
                    <th>Fecha Inicio</th>
                    <th>Fecha Fin</th>
                    <th>Motivo</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $permisos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permiso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <?php echo e($permiso->empleado->user->nombres); ?>

                        <?php echo e($permiso->empleado->user->apellido_paterno); ?>

                    </td>

                    <td><?php echo e($permiso->fecha_inicio); ?></td>
                    <td><?php echo e($permiso->fecha_fin); ?></td>
                    <td><?php echo e($permiso->motivo); ?></td>

                    <td>
                        <?php
                        $badgeClass = match ($permiso->estado) {
                        'PENDIENTE' => 'secondary',
                        'APROBADO' => 'success',
                        'RECHAZADO' => 'danger',
                        default => 'dark',
                        };
                        ?>

                        <span class="badge bg-<?php echo e($badgeClass); ?>">
                            <?php echo e($permiso->estado); ?>

                        </span>
                    </td>

                    <td>
                        <a href="<?php echo e(route('permisos.edit', $permiso)); ?>"
                            class="btn btn-sm btn-outline-secondary">
                            Editar
                        </a>
                    </td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted">
                        No hay permisos registrados.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/permisos/index.blade.php ENDPATH**/ ?>