

<?php $__env->startSection('title', 'Editar Permiso'); ?>

<?php $__env->startSection('content'); ?>

<div class="container d-flex justify-content-center">

    <div class="card shadow p-4 w-100 mg-card" style="max-width: 700px;">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Editar Permiso</h5>
            <a href="<?php echo e(route('permisos.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('permisos.update', $permiso)); ?>" method="POST" class="mg-form">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label class="form-label">Empleado</label>
                <input type="text"
                    class="form-control"
                    value="<?php echo e($permiso->empleado->user->nombres); ?> <?php echo e($permiso->empleado->user->apellido_paterno); ?>"
                    disabled>
                <input type="hidden" name="empleado_id" value="<?php echo e($permiso->empleado_id); ?>">
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="fecha_inicio" class="form-label">Fecha de Inicio</label>
                    <input type="date"
                        name="fecha_inicio"
                        id="fecha_inicio"
                        class="form-control"
                        value="<?php echo e($permiso->fecha_inicio); ?>"
                        required>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="fecha_fin" class="form-label">Fecha de Fin</label>
                    <input type="date"
                        name="fecha_fin"
                        id="fecha_fin"
                        class="form-control"
                        value="<?php echo e($permiso->fecha_fin); ?>"
                        required>
                </div>
            </div>

            <div class="mb-3">
                <label for="motivo" class="form-label">Motivo del Permiso</label>
                <textarea name="motivo"
                    id="motivo"
                    class="form-control"
                    rows="3"
                    required><?php echo e($permiso->motivo); ?></textarea>
            </div>

            <div class="mb-3">
                <label for="estado" class="form-label">Estado</label>
                <select name="estado" id="estado" class="form-select" required>
                    <option value="PENDIENTE" <?php echo e($permiso->estado == 'PENDIENTE'  ? 'selected' : ''); ?>>PENDIENTE</option>
                    <option value="APROBADO" <?php echo e($permiso->estado == 'APROBADO'   ? 'selected' : ''); ?>>APROBADO</option>
                    <option value="RECHAZADO" <?php echo e($permiso->estado == 'RECHAZADO'  ? 'selected' : ''); ?>>RECHAZADO</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="comentario" class="form-label">Comentario (opcional)</label>
                <textarea name="comentario"
                    id="comentario"
                    class="form-control"
                    rows="2"><?php echo e($permiso->comentario); ?></textarea>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">Actualizar Permiso</button>
            </div>

        </form>

    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/permisos/edit.blade.php ENDPATH**/ ?>