

<?php $__env->startSection('title', 'Parámetros Personalizados por Empleado'); ?>

<?php $__env->startSection('content'); ?>

<div class="container d-flex justify-content-center mt-4">
    <div class="card shadow p-4 mg-card w-100" style="max-width: 800px;">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">
                Parámetros Personalizados –
                <?php echo e($empleado->user->nombres ?? ''); ?>

                <?php echo e($empleado->user->apellido_paterno ?? ''); ?>

            </h5>

            <a href="<?php echo e(route('parametros.index')); ?>" class="btn btn-sm btn-outline-secondary">← Volver</a>
        </div>

        <div class="alert alert-info">
            <strong>Nota:</strong> Si dejas un campo vacío, se aplicará el valor general.
        </div>

        <form method="POST" action="<?php echo e(route('parametros.empleado.update', $empleado)); ?>" class="mg-form">
            <?php echo csrf_field(); ?>

            <div class="table-responsive">
                <table class="table mg-table table-bordered align-middle text-center">
                    <thead>
                        <tr>
                            <th>Clave</th>
                            <th>Descripción</th>
                            <th>Valor General</th>
                            <th>Personalizado</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $parametrosGenerales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parametro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $clave = $parametro->clave;
                        $valorPersonalizado = $parametrosEmpleado[$clave]->valor ?? null;
                        ?>

                        <tr>
                            <td><strong><?php echo e($clave); ?></strong></td>

                            <td><?php echo e($parametro->descripcion ?? '-'); ?></td>

                            <td>
                                <?php if($parametro->valor !== null): ?>
                                <?php echo e(number_format($parametro->valor, 2)); ?> Bs
                                <?php else: ?>
                                <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>

                            <td>
                                <input type="number"
                                    name="<?php echo e($clave); ?>"
                                    class="form-control"
                                    value="<?php echo e(old($clave, $valorPersonalizado)); ?>"
                                    step="0.01" min="0"
                                    placeholder="Ej: 100.00">
                            </td>
                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-end gap-2 mt-4">
                <a href="<?php echo e(route('parametros.index')); ?>" class="btn btn-outline-secondary">Cancelar</a>
                <button type="submit" class="btn btn-primary">Guardar Cambios</button>
            </div>

        </form>

    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/parametros/empleado.blade.php ENDPATH**/ ?>