

<?php $__env->startSection('title', 'Listado de Horarios'); ?>

<?php $__env->startSection('content'); ?>

<div class="container" style="max-width: 1000px;">

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3 text-center text-md-start">
        <h2 class="mb-3 mb-md-0" style="color:#FCCB00;">Listado de Horarios</h2>
        <a href="<?php echo e(route('horarios.create')); ?>" class="btn btn-primary">+ Crear nuevo horario</a>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="table-responsive">
        <table class="table mg-table table-bordered table-hover align-middle text-center">
            <thead>
                <tr>
                    <th>Empleado</th>
                    <th>Hora Entrada</th>
                    <th>Hora Salida</th>
                    <th>Nombre Turno</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $horarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <?php echo e($horario->empleado?->user?->nombres ?? 'General'); ?>

                        <?php echo e($horario->empleado?->user?->apellido_paterno ?? ''); ?>

                    </td>

                    <td><?php echo e($horario->hora_entrada); ?></td>
                    <td><?php echo e($horario->hora_salida); ?></td>
                    <td><?php echo e($horario->nombre_turno ?? '-'); ?></td>

                    <td>
                        <a href="<?php echo e(route('horarios.edit', $horario)); ?>" class="btn btn-sm btn-warning">Editar</a>

                        <form action="<?php echo e(route('horarios.destroy', $horario)); ?>"
                            method="POST"
                            style="display:inline-block;"
                            onsubmit="return confirm('¿Eliminar este horario?')">

                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>

                            <button class="btn btn-sm btn-danger" type="submit">Eliminar</button>
                        </form>
                    </td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">
                        No hay horarios registrados.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/horarios/index.blade.php ENDPATH**/ ?>