

<?php $__env->startSection('title', 'Parámetros del Sistema'); ?>

<?php $__env->startSection('content'); ?>

<div class="container mt-4" style="max-width: 1100px;">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="mb-0" style="color:#FCCB00;">Parámetros Generales del Sistema</h3>
        <a href="<?php echo e(route('parametros.create')); ?>" class="btn btn-primary">
            + Nuevo Parámetro
        </a>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success text-center">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <div class="table-responsive">
        <table class="table mg-table table-bordered table-hover align-middle text-center">
            <thead>
                <tr>
                    <th>Clave</th>
                    <th>Descripción</th>
                    <th>Valor Actual</th>
                    <th>Acción</th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $parametros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parametro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><strong><?php echo e($parametro->clave); ?></strong></td>

                    <td><?php echo e($parametro->descripcion ?? 'Sin descripción'); ?></td>

                    <td>
                        <?php if($parametro->valor !== null): ?>
                        <?php echo e(number_format($parametro->valor, 2)); ?> Bs
                        <?php else: ?>
                        <em class="text-muted">No asignado</em>
                        <?php endif; ?>
                    </td>

                    <td>
                        <a href="<?php echo e(route('parametros.edit', $parametro)); ?>" class="btn btn-sm btn-warning">
                            Editar
                        </a>
                    </td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="text-center text-muted">
                        No hay parámetros configurados aún.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <h4 class="mt-5 mb-3" style="color:#FCCB00;">Parámetros Personalizados por Empleado</h4>
    <p style="color:#FCCB00;">Haz clic en un empleado para configurar valores específicos que sobreescriban los generales.</p>

    <div class="row row-cols-1 row-cols-md-3 g-3">

        <?php $__empty_1 = true; $__currentLoopData = $empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empleado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col">
            <div class="card h-100 mg-card p-3">

                <h6 class="mb-1"><?php echo e($empleado->user->nombres ?? 'Sin nombre'); ?></h6>

                <p class="mb-2">
                    <strong>CI:</strong> <?php echo e($empleado->ci); ?><br>
                    <strong>Código:</strong> <?php echo e($empleado->codigo); ?><br>
                    <strong>Salario:</strong> <?php echo e(number_format($empleado->salario_mensual ?? 0, 2)); ?> Bs
                </p>

                <a href="<?php echo e(route('parametros.empleado', $empleado)); ?>" class="btn btn-sm btn-outline-secondary">
                    Configurar Parámetros
                </a>

            </div>
        </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-muted">No hay empleados registrados.</p>
        <?php endif; ?>

    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/parametros/index.blade.php ENDPATH**/ ?>