

<?php $__env->startSection('title', 'Lista de Empleados'); ?>

<?php $__env->startSection('content'); ?>

<div class="container" style="max-width: 1200px;">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="mb-0" style="color:#FCCB00;">Lista de Empleados</h3>
        <a href="<?php echo e(route('empleados.create')); ?>" class="btn btn-primary">+ Nuevo Empleado</a>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <?php if($empleados->isEmpty()): ?>

    <p class="text-light">No hay empleados registrados.</p>

    <?php else: ?>

    <div class="table-responsive">
        <table class="table mg-table table-bordered table-hover align-middle text-center">

            <thead>
                <tr>
                    <th>Foto</th>
                    <th>Nombre Completo</th>
                    <th>CI</th>
                    <th>Código</th>
                    <th>Celular</th>
                    <th>Salario</th>
                    <th>Edad</th>
                    <th>Ingreso</th>
                    <th>Retiro</th>
                    <th>Referencia 1</th>
                    <th>Referencia 2</th>
                    <th>Ubicación</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empleado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    
                    <td>
                        <?php if($empleado->foto): ?>
                        <img src="<?php echo e(asset('storage/' . $empleado->foto)); ?>"
                            alt="Foto" width="50" height="50"
                            class="rounded-circle">
                        <?php else: ?>
                        <span class="text-muted">Sin foto</span>
                        <?php endif; ?>
                    </td>

                    
                    <td>
                        <?php echo e($empleado->user->nombres ?? ''); ?>

                        <?php echo e($empleado->user->apellido_paterno ?? ''); ?>

                        <?php echo e($empleado->user->apellido_materno ?? ''); ?>

                    </td>

                    <td><?php echo e($empleado->ci); ?></td>
                    <td><?php echo e($empleado->codigo); ?></td>
                    <td><?php echo e($empleado->celular); ?></td>
                    <td><?php echo e($empleado->salario_mensual); ?></td>
                    <td><?php echo e($empleado->edad); ?></td>

                    <td><?php echo e(\Carbon\Carbon::parse($empleado->fecha_ingreso)->format('d/m/Y')); ?></td>

                    <td>
                        <?php if($empleado->fecha_retiro): ?>
                        <?php echo e(\Carbon\Carbon::parse($empleado->fecha_retiro)->format('d/m/Y')); ?>

                        <?php else: ?>
                        <span class="text-muted">Activo</span>
                        <?php endif; ?>
                    </td>

                    
                    <td>
                        <strong><?php echo e($empleado->referencia_1_nombre); ?></strong><br>
                        <small><?php echo e($empleado->referencia_1_celular); ?></small>
                    </td>

                    
                    <td>
                        <?php if($empleado->referencia_2_nombre): ?>
                        <strong><?php echo e($empleado->referencia_2_nombre); ?></strong><br>
                        <small><?php echo e($empleado->referencia_2_celular); ?></small>
                        <?php else: ?>
                        <span class="text-muted">No registrada</span>
                        <?php endif; ?>
                    </td>

                    
                    <td>
                        <?php if($empleado->ubicacion_domicilio): ?>
                        <a href="<?php echo e($empleado->ubicacion_domicilio); ?>" target="_blank"
                            class="btn btn-sm btn-outline-secondary">
                            Ver
                        </a>
                        <?php else: ?>
                        <span class="text-muted">No registrada</span>
                        <?php endif; ?>
                    </td>

                    
                    <td>
                        <a href="<?php echo e(route('empleados.edit', $empleado)); ?>"
                            class="btn btn-sm btn-warning">Editar</a>

                        <form action="<?php echo e(route('empleados.destroy', $empleado)); ?>"
                            method="POST" style="display:inline-block;"
                            onsubmit="return confirm('¿Seguro que deseas eliminar este empleado?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-danger" type="submit">
                                Eliminar
                            </button>
                        </form>
                    </td>

                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>
    </div>

    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\controlPersonal\resources\views/empleados/index.blade.php ENDPATH**/ ?>