<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('parametros', function (Blueprint $table) {
            $table->id();
            $table->string('clave')->unique(); // Ej: monto_por_falta
            $table->string('descripcion')->nullable();
            $table->decimal('valor', 10, 2)->nullable(); // ← Puede quedar vacío hasta que el usuario defina
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('parametros');
    }
};
